The following table aims to capture the Golang types supported for each ClickHouse Column Type. 

Whilst each ClickHouse type often has a logical Golang type, we aim to support implicit conversions where possible and provided no precision loss will be incurred - thus alleviating the need for users to ensure their data aligns perfectly with ClickHouse types.

This effort is ongoing and can be seperated in to insertion (`Append`/`AppendRow`) and read time (via a `Scan`). Should you need support for a specific conversion, please raise an issue.

## Append Support

All types can be inserted as a value or pointer.

|                  | **ClickHouse Type** | String | Decimal | Boolean | FixedString | UInt8 | UInt16 | UInt32 | UInt64 | UInt128 | UInt256 | Int8 | Int16 | Int32 | Int64 | Int128 | Int256 | Float32 | Float64 | UUID | Date | Date32 | DateTime | DateTime64 | Enum8 | Enum16 | Point | Ring | Polygon | MultiPolygon |
|------------------|---------------------|--------|---------|---------|-------------|-------|--------|--------|--------|---------|---------|------|-------|-------|-------|--------|--------|---------|---------|------|------|--------|----------|------------|-------|--------|-------|------|---------|--------------|
| **Golang Type**  |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint             |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| unit64           |                     |        |         |         |             |       |        |        |    X   |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint32           |                     |        |         |         |             |       |        |    X   |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint16           |                     |        |         |         |             |       |    X   |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint8            |                     |        |         |         |             |   X   |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int              |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |   X   |    X   |       |      |         |              |
| int64            |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |   X   |        |        |         |         |      |      |        |     X    |      X     |       |        |       |      |         |              |
| int32            |                     |        |         |         |             |       |        |        |        |         |         |      |       |   X   |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int16            |                     |        |         |         |             |       |        |        |        |         |         |      |   X   |       |       |        |        |         |         |      |      |        |          |            |       |    X   |       |      |         |              |
| int8             |                     |        |         |         |             |       |        |        |        |         |         |   X  |       |       |       |        |        |         |         |      |      |        |          |            |   X   |        |       |      |         |              |
| float32          |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |    X    |         |      |      |        |          |            |       |        |       |      |         |              |
| float64          |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |    X    |      |      |        |          |            |       |        |       |      |         |              |
| string           |                     |    X   |         |         |      X      |       |        |        |        |         |         |      |       |       |       |        |        |         |         |   X  |   X  |    X   |     X    |      X     |   X   |    X   |       |      |         |              |
| boolean          |                     |        |         |    X    |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| time.Time        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |   X  |    X   |     X    |      X     |       |        |       |      |         |              |
| big.Int          |                     |        |         |         |             |       |        |        |        |    X    |    X    |      |       |       |       |    X   |    X   |         |         |      |      |        |          |            |       |        |       |      |         |              |
| decimal.Decimal  |                     |        |    X    |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uuid.UUID        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |   X  |      |        |          |            |       |        |       |      |         |              |
| orb.Point        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |   X   |      |         |              |
| orb.Polygon      |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |    X    |              |
| orb.Ring         |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |   X  |         |              |
| orb.MultiPolygon |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |       X      |
| []byte           |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |       X      |
 | fmt.Stringer     |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullString   |                     |    X   |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullTime     |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |   X  |    X   |     X    |      X     |       |        |       |      |         |              |
| sql.NullFloat64  |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |    X    |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt64    |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |   X   |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt32    |                     |        |         |         |             |       |        |        |        |         |         |      |       |   X   |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt16    |                     |        |         |         |             |       |        |        |        |         |         |      |   X   |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullBool     |                     |        |         |    X    |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |

## Scan Support

All types can be read into a pointer or pointer to a pointer.

|                  | **ClickHouse Type** | String | Decimal | Boolean | FixedString | UInt8 | UInt16 | UInt32 | UInt64 | UInt128 | UInt256 | Int8 | Int16 | Int32 | Int64 | Int128 | Int256 | Float32 | Float64 | UUID | Date | Date32 | DateTime | DateTime64 | Enum8 | Enum16 | Point | Ring | Polygon | MultiPolygon |
|------------------|---------------------|--------|---------|---------|-------------|-------|--------|--------|--------|---------|---------|------|-------|-------|-------|--------|--------|---------|---------|------|------|--------|----------|------------|-------|--------|-------|------|---------|--------------|
| **Golang Type**  |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint             |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| unit64           |                     |        |         |         |             |       |        |        |    X   |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint32           |                     |        |         |         |             |       |        |    X   |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint16           |                     |        |         |         |             |       |    X   |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uint8            |                     |        |         |         |             |   X   |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int              |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int64            |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |   X   |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int32            |                     |        |         |         |             |       |        |        |        |         |         |      |       |   X   |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int16            |                     |        |         |         |             |       |        |        |        |         |         |      |   X   |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| int8             |                     |        |         |         |             |       |        |        |        |         |         |   X  |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| float32          |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |    X    |         |      |      |        |          |            |       |        |       |      |         |              |
| float64          |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |    X    |      |      |        |          |            |       |        |       |      |         |              |
| string           |                     |    X   |         |         |      X      |       |        |        |        |         |         |      |       |       |       |        |        |         |         |   X  |      |        |          |            |   X   |    X   |       |      |         |              |
| boolean          |                     |        |         |    X    |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| time.Time        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |   X  |    X   |     X    |      X     |       |        |       |      |         |              |
| big.Int          |                     |        |         |         |             |       |        |        |        |    X    |    X    |      |       |       |       |    X   |    X   |         |         |      |      |        |          |            |       |        |       |      |         |              |
| decimal.Decimal  |                     |        |    X    |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| uuid.UUID        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |   X  |      |        |          |            |       |        |       |      |         |              |
| orb.Point        |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |   X   |      |         |              |
| orb.Polygon      |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |    X    |              |
| orb.Ring         |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |   X  |         |              |
| orb.MultiPolygon |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |       X      |
| sql.Scan         |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |   X  |   X  |    X   |     X    |      X     |       |        |       |      |         |              |
| sql.NullString   |                     |    X   |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullTime     |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |   X  |    X   |     X    |      X     |       |        |       |      |         |              |
| sql.NullFloat64  |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |       |        |        |         |    X    |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt64    |                     |        |         |         |             |       |        |        |        |         |         |      |       |       |   X   |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt32    |                     |        |         |         |             |       |        |        |        |         |         |      |       |   X   |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullInt16    |                     |        |         |         |             |       |        |        |        |         |         |      |   X   |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
| sql.NullBool     |                     |        |         |    X    |             |       |        |        |        |         |         |      |       |       |       |        |        |         |         |      |      |        |          |            |       |        |       |      |         |              |
