---
date: "2023-05-23T09:00:00+08:00"
title: "权限"
slug: "permissions"
sidebar_position: 14
toc: false
draft: false
aliases:
  - /zh-cn/permissions
menu:
  sidebar:
    parent: "usage"
    name: "权限"
    sidebar_position: 14
    identifier: "permissions"
---

# 权限

Gitea 支持对仓库进行权限管理，这样您就可以为不同的人员提供不同的访问权限。首先，我们需要了解 `单元（Unit）`。

## 单元（Unit）

在 Gitea 中，我们将仓库的子模块称为 `单元（Unit）`。现在我们有以下几个单元。

| 名称              | 描述                                                | 权限         |
| ----------------- | --------------------------------------------------- | ------------ |
| 代码              | 访问源代码、文件、提交和分支。                       | 读取 写入    |
| 工单              | 组织缺陷报告、任务和里程碑。                        | 读取 写入    |
| 合并请求          | 启用合并请求和代码审核。                             | 读取 写入    |
| 发布              | 跟踪项目版本和下载。                                | 读取 写入    |
| 维基              | 与协作者编写和共享文档。                            | 读取 写入    |
| 外部维基          | 链接到外部维基。                                    | 读取         |
| 外部工单跟踪器    | 链接到外部工单跟踪器。                              | 读取         |
| 项目              | 模板仓库的 URL。                                   | 读取 写入    |
| 设置              | 管理仓库。                                         | 管理员       |

通过不同的权限，用户可以在这些单元上执行不同的操作。

| 名称              | 读取                                                | 写入                           | 管理员                     |
| ----------------- | -------------------------------------------------- | ------------------------------ | ------------------------- |
| 代码              | 查看代码树、文件、提交、分支等。                     | 推送代码。                     | -                         |
| 工单              | 查看工单并创建新工单。                              | 添加标签、分配、关闭工单。     | -                         |
| 合并请求          | 查看合并请求并创建新合并请求。                       | 添加标签、分配、关闭合并请求。 | -                         |
| 发布              | 查看发布和下载文件。                                | 创建/编辑发布。                | -                         |
| 维基              | 查看维基页面。克隆维基仓库。                        | 创建/编辑维基页面，推送更改。 | -                         |
| 外部维基          | 链接到外部维基。                                    | -                             | -                         |
| 外部工单跟踪器    | 链接到外部工单跟踪器。                              | -                             | -                         |
| 项目              | 查看面板。                                         | 在面板之间移动工单。           | -                         |
| 设置              | -                                                  | -                             | 管理仓库                   |

个人仓库和组织仓库之间的权限存在一些差异。

## 个人仓库

对于个人仓库，创建者是仓库的唯一所有者，对于该仓库的任何更改或删除没有限制。仓库所有者可以添加协作者来帮助维护仓库。协作者可以拥有 `读取（Read）`、`写入（Write）` 和 `管理员（Admin）` 权限。

## 组织仓库

与个人仓库不同，组织仓库的所有者是组织的所有者团队。

### 团队

组织中的一个团队具有单元权限设置。它可以拥有成员和仓库的范围。团队可以访问组织中的所有仓库或者由所有者团队授权访问的特定仓库。团队也可以被允许创建新的仓库。

所有者团队（Owners）将在创建组织时自动创建，并且创建者将成为所有者团队的第一个成员。
组织的每个成员必须至少属于一个团队。所有者团队不能被删除，只有所有者团队的成员可以创建新的团队。可以创建一个管理员团队来管理某些仓库，该团队的成员可以对这些仓库进行任何操作。可以由所有者团队创建一个生成团队来执行其权限允许的操作。
