---
date: "2023-05-23T09:00:00+08:00"
title: "自动链接引用"
slug: "automatically-linked-references"
sidebar_position: 15
toc: false
draft: false
aliases:
  - /zh-cn/automatically-linked-references
menu:
  sidebar:
    parent: "usage"
    name: "自动链接引用s"
    sidebar_position: 15
    identifier: "automatically-linked-references"
---

# 在工单、合并请求和提交消息中的自动链接引用

当发布工单、合并请求或评论时，文本描述会被解析以查找引用。这些引用将显示为工单视图中的链接，并且在某些情况下会触发特定的“操作”。

类似地，当列出提交消息时，它们也会被解析，并且当它们被推送到主分支时可以触发“操作”。

为了防止意外创建引用，对于引用的识别有一定的规则。例如，它们不应该包含在代码文本内部。它们还应该在周围的文本中合理清晰（例如，使用空格）。

## 用户、团队和组织提及

当找到形式为 `@username` 的文本，并且 `username` 与现有用户的名称匹配时，将创建一个“提及”引用。这将通过将文本更改为指向该用户个人资料的链接来显示，并根据被提及的用户是否具有访问内容所需的权限来可能创建通知。

示例：

> [@John](#)，你能看一下这个吗？

对于团队和组织也是有效的：

> [@Documenters](#)，我们需要为此进行规划。
> [@CoolCompanyInc](#)，这个问题关系到我们所有人！

团队将在适当时收到邮件通知，但整个组织不会收到通知。

提交消息不会产生用户通知。

## 提交

可以使用提交的 SHA1 哈希或至少七个字符的一部分来引用提交。它们将显示为指向相应提交的链接。

示例：

> 这个错误是在 [e59ff077](#) 中引入的

## 工单和合并请求

可以使用简单的符号 `#1234` 来创建对另一个工单或合并请求的引用，其中 _1234_ 是同一仓库中一个工单或合并请求的编号。这些引用将显示为指向被引用内容的链接。

创建此类型引用的效果是，在被引用的文档中创建一个“通知”，前提是引用的创建者对其具有读取权限。

示例：

> 这似乎与 [#1234](#) 相关

还可以使用形式 `owner/repository#1234` 来引用其他仓库中的工单和合并请求：

> 这似乎与 [mike/compiler#1234](#) 相关

或者也可以使用 `!1234` 符号。虽然在 Gitea 中合并请求是工单的一种形式，但 `#1234` 形式总是链接到工单；如果链接的条目恰好是一个合并请求，Gitea 会适当地进行重定向。而使用 `!1234` 符号，则会创建一个合并请求链接，根据需要会被重定向到工单。然而，如果使用外部跟踪器，这个区别可能很重要，因为工单和合并请求的链接是不能互换的。

## 可操作的引用在合并请求和提交消息中

有时，一个提交或合并请求可能会修复或重新出现在某个特定工单中。Gitea 支持在引用之前加上特定的“关键字”来关闭和重新打开被引用的工单。常见的关键字包括“closes”、“fixes”、“reopens”等。这个列表可以由站点管理员进行 [自定义](administration/config-cheat-sheet.md)。

示例：

> 这个合并请求 _closes_ [#1234](#)

如果可操作的引用被接受，这将在被引用的工单上创建一个通知，宣布当引用的合并请求被合并时该工单将被关闭。

为了接受可操作的引用，必须满足以下至少一项条件之一：

- 评论者在创建引用时具有关闭或重新打开工单的权限。
- 引用位于提交消息中。
- 引用作为合并请求描述的一部分发布。

在最后一种情况下，只有当合并合并请求的人具有相应权限时，工单才会被关闭或重新打开。

此外，只有合并请求和提交消息可以创建一个操作，只有工单可以通过这种方式被关闭或重新打开。

默认的关键字如下：

- **关闭工单**: close, closes, closed, fix, fixes, fixed, resolve, resolves, resolved
- **重新打开工单**: reopen, reopens, reopened

## 合并请求和提交消息中的时间跟踪

当提交或合并合并请求导致自动关闭工单时，还可以通过提交消息添加解决此工单所花费的时间。

要指定解决工单所花费的时间，需要在工单编号后面以 `@<number><time-unit>` 的格式指定时间。在一个提交消息中，可以指定多个已解决的工单，并为每个工单指定花费的时间。

支持的时间单位（`<time-unit>`）：

- `m` - 分钟
- `h` - 小时
- `d` - 天（相当于8小时）
- `w` - 周（相当于5天）
- `mo` - 月（相当于4周）

用于指定时间的数字（`<number>`）也可以是小数，例如 `@1.5h` 表示一小时半。多个时间单位可以结合使用，例如 `@1h10m` 表示1小时10分钟。

提交消息示例：

> Fixed #123 spent @1h, refs #102, fixes #124 @1.5h

这将导致工单 #123 增加 1 小时，工单 #124 增加 1 小时半。

## 外部跟踪器

Gitea 支持使用外部工单跟踪器，并可以在合并请求中创建对外部托管的工单的引用。但是，如果外部跟踪器使用数字来标识工单，那么它们将与 Gitea 中托管的合并请求无法区分。为了解决这个工单，Gitea 允许使用 `!` 标记来标识合并请求。例如：

> 这是工单 [#1234](#)，并链接到外部跟踪器。
> 这是合并请求 [!1234](#)，并链接到 Gitea 中的合并请求。

在工单和合并请求中，`!` 和 `#` 可以互换使用，除非需要进行区分。如果仓库使用外部跟踪器，默认情况下，合并提交消息将使用 `!` 作为引用。

## 工单和合并请求引用摘要

下表说明了工单和合并请求的不同类型的交叉引用。在示例中，`User1/Repo1` 指的是使用引用的仓库，而 `UserZ/RepoZ` 表示另一个仓库。

| 在 User1/Repo1 中的引用  | Repo1 的工单是外部的 | RepoZ 的工单是外部的 | 渲染效果                                         |
| ----------------------- | :-------------------: | :-------------------: | ------------------------------------------------ |
| `#1234`                 |          否           |          -            | 链接到 `User1/Repo1` 中的工单/合并请求 1234      |
| `!1234`                 |          否           |          -            | 链接到 `User1/Repo1` 中的工单/合并请求 1234      |
| `#1234`                 |          是           |          -            | 链接到 `User1/Repo1` 的 _外部工单_ 1234           |
| `!1234`                 |          是           |          -            | 链接到 `User1/Repo1` 的 _PR_ 1234                 |
| `User1/Repo1#1234`      |          否           |          -            | 链接到 `User1/Repo1` 中的工单/合并请求 1234      |
| `User1/Repo1!1234`      |          否           |          -            | 链接到 `User1/Repo1` 中的工单/合并请求 1234      |
| `User1/Repo1#1234`      |          是           |          -            | 链接到 `User1/Repo1` 的 _外部工单_ 1234           |
| `User1/Repo1!1234`      |          是           |          -            | 链接到 `User1/Repo1` 的 _PR_ 1234                 |
| `UserZ/RepoZ#1234`      |          -            |          否           | 链接到 `UserZ/RepoZ` 中的工单/合并请求 1234      |
| `UserZ/RepoZ!1234`      |          -            |          否           | 链接到 `UserZ/RepoZ` 中的工单/合并请求 1234      |
| `UserZ/RepoZ#1234`      |          -            |          是           | 链接到 `UserZ/RepoZ` 的 _外部工单_ 1234           |
| `UserZ/RepoZ!1234`      |          -            |          是           | 链接到 `UserZ/RepoZ` 的 _PR_ 1234                 |
| **字母数字工单编号:**    |           -           |          -            | -                                                |
| `AAA-1234`              |          是           |          -            | 链接到 `User1/Repo1` 的 _外部工单_ `AAA-1234`      |
| `!1234`                 |          是           |          -            | 链接到 `User1/Repo1` 的 _PR_ 1234                 |
| `User1/Repo1!1234`      |          是           |          -            | 链接到 `User1/Repo1` 的 _PR_ 1234                 |
| _不支持_                |          -            |          是           | 链接到 `UserZ/RepoZ` 的 _外部工单_ `AAA-1234`      |
| `UserZ/RepoZ!1234`      |          -            |          是           | 链接到 `UserZ/RepoZ` 中的 _PR_ 1234               |

_最后一部分适用于使用字母数字格式的外部工单跟踪器的仓库。_

_**-**: 不适用_

注意：不完全支持具有不同类型工单（外部 vs. 内部）的仓库之间的自动引用，可能会导致无效链接。
